/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdripper.recipe;

import com.google.gson.JsonObject;
import dev.ftb.mods.ftbdripper.recipe.DripRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DripRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<DripRecipe> {
    public DripRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        DripRecipe r = new DripRecipe(recipeId, json.has("group") ? json.get("group").getAsString() : "");
        if (json.has("inputBlock")) {
            r.setInputString(json.get("inputBlock").getAsString());
        }
        if (json.has("inputItem")) {
            r.inputItem = json.get("inputItem").isJsonObject() ? ShapedRecipe.m_151274_((JsonObject)json.get("inputItem").getAsJsonObject()) : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("inputItem").getAsString())));
        }
        if (json.has("outputBlock")) {
            r.setOutputString(json.get("outputBlock").getAsString());
        }
        if (json.has("outputItem")) {
            r.outputItem = json.get("outputItem").isJsonObject() ? ShapedRecipe.m_151274_((JsonObject)json.get("outputItem").getAsJsonObject()) : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("outputItem").getAsString())));
        }
        if (json.has("fluid")) {
            r.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(json.get("fluid").getAsString()));
        }
        if (json.has("chance")) {
            r.chance = json.get("chance").getAsDouble();
        }
        return r;
    }

    public DripRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        DripRecipe r = new DripRecipe(recipeId, buffer.m_130136_(Short.MAX_VALUE));
        r.setInputString(buffer.m_130136_(Short.MAX_VALUE));
        r.inputItem = buffer.m_130267_();
        r.setOutputString(buffer.m_130136_(Short.MAX_VALUE));
        r.outputItem = buffer.m_130267_();
        r.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.m_130281_());
        r.chance = buffer.readDouble();
        return r;
    }

    public void toNetwork(FriendlyByteBuf buffer, DripRecipe r) {
        buffer.m_130072_(r.m_6076_(), Short.MAX_VALUE);
        buffer.m_130072_(r.getInputString(), Short.MAX_VALUE);
        buffer.m_130055_(r.inputItem);
        buffer.m_130072_(r.getOutputString(), Short.MAX_VALUE);
        buffer.m_130055_(r.outputItem);
        buffer.m_130085_(r.fluid.getRegistryName());
        buffer.writeDouble(r.chance);
    }
}

